<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>FIE Burkina - Plaintes et Suggestions</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        :root {
            --primary-color: #018d37;
            --primary-color-hover: #1a4229;
            --secondary-color: #39a1cd;
            --tertiary-color: #018d37;
            --white-color: #fff;
            --black-color: #000;
            --gray-color: #333;
            --gray-color-hover: #666;
            --background-color: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-color-hover) 100%);
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background-image: url("{{ asset('assets/images/forest.jpg') }}") ;
            /* background-color: red; */

            min-height: 100vh;
        }
        .bg-white{
          background-color: var(--white-color);
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        .container-full {
            width: 100%;
            margin: 0 0 0 0;
            padding: 0 20px;
        }
        nav{
          width: 100%;
          padding: 20px 0;
        }

        /* Header */
        header {
            background: rgba(1, 141, 55, 0.7);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.2);
            padding:  0;
            position: sticky;
            top: 0;
            z-index: 1000;
        }

        .header-content {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .logo {
            color: white;
            font-size: 1.8rem;
            font-weight: bold;
            text-decoration: none;
        }

        .nav-links {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 2rem;
            list-style: none;
        }

        .nav-links a {
            color: white;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
            padding: 0.5rem 1rem;
            border-bottom: 3px solid white;
            /* box-shadow: 0 10px 4px rgba(0,0,0,0.3); */
            border-radius: 3px;
        }

        .nav-links a:hover {
            background: rgba(255, 255, 255, 0.2);
            transform: translateY(-20px);
        }

        /* Top Banner */
        .top-banner {
          background-color: white;
            /* background: linear-gradient(135deg, #2e8b57, #228b22); */
            /* color: white; */
            color: #2e8b57;
            padding: 1rem 0;
        }

        .banner-content {
            display: flex;
            align-items: center;
            justify-content: center;
            
            gap: 1rem;
            flex-wrap: wrap;
        }

        .fie-logo {
            width: 60px;
            height: 60px;
            background: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            vertical-align: middle;
            font-weight: bold;
            color: #2e8b57;
            font-size: 0.9rem;
            text-align: center;
            line-height: 1.2;
            border: 3px solid rgba(255,255,255,0.3);
        }
        .fie-logo img{
            width: 80px;
            height: 80px;
            border-radius: 50%;
        }

        .banner-text {
            /* text-align: center; */
        }

        .banner-title {
            font-size: 2.5rem;
            font-weight: bold;
            margin-bottom: 0.25rem;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
        }

        .banner-subtitle {
            font-size: 1.5rem;
            font-style: italic;
            opacity: 0.9;
            font-weight: 300;
        }

        /* Hero Section */
        .hero {
            padding: 4rem 0;
            text-align: center;
            color: white;
        }

        .hero h1 {
            font-size: 3.5rem;
            margin-bottom: 1rem;
            background: linear-gradient(45deg, #fff, #f0f0f0);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            /* text-shadow: 0 2px 4px rgba(0,0,0,0.3); */
        }

        .hero p {
            font-size: 1.3rem;
            margin-bottom: 2rem;
            opacity: 0.9;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
        }

        .cta-buttons {
            display: flex;
            gap: 1rem;
            justify-content: center;
            flex-wrap: wrap;
        }

        .btn {
            padding: 1rem 2rem;
            border: none;
            border-radius: 50px;
            font-size: 1.1rem;
            font-weight: 600;
            text-decoration: none;
            cursor: pointer;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            box-shadow: 0 4px 15px rgba(0,0,0,0.2);
        }

        .btn-primary {
            background: linear-gradient(45deg, #ff6b6b, #ee5a24);
            color: white;
        }

        .btn-secondary {
            background: rgba(255, 255, 255, 0.2);
            color: white;
            border: 2px solid rgba(255, 255, 255, 0.3);
        }

        .btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.3);
        }

        /* Main Content */
        main {
            background: white;
            border-radius: 30px 30px 0 0;
            margin-top: 2rem;
            position: relative;
            overflow: hidden;
        }

        .content-section {
            padding: 4rem 0;
        }

        .section-header {
            text-align: center;
            margin-bottom: 3rem;
        }

        .section-header h2 {
            font-size: 2.5rem;
            color: #333;
            margin-bottom: 1rem;
            position: relative;
        }

        .section-header h2::after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 4px;
            background: linear-gradient(45deg, #018d37, #018d37);
            border-radius: 2px;
        }

        /* Process Steps */
        .process-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 2rem;
            margin: 3rem 0;
        }

        .process-card {
            background: linear-gradient(135deg, #f8f9fa, #e9ecef);
            padding: 2rem;
            border-radius: 20px;
            text-align: center;
            transition: all 0.3s ease;
            border: 1px solid var(--secondary-color);
            position: relative;
            overflow: hidden;
        }

        .process-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(45deg, #667eea, #764ba2);
        }

        .process-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.15);
        }

        .process-icon {
            font-size: 3rem;
            color: var(--primary-color);
            margin-bottom: 1rem;
        }

        .process-card h3 {
            font-size: 1.5rem;
            margin-bottom: 1rem;
            color: #333;
        }

        /* Principles Grid */
        .principles-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin: 3rem 0;
        }

        .principle-item {
            background: white;
            padding: 1.5rem;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            border-left: 5px solid var(--secondary-color);
            transition: all 0.3s ease;
        }

        .principle-item:hover {
            transform: translateX(5px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.15);
        }

        .principle-item h4 {
            font-size: 1.2rem;
            margin-bottom: 0.5rem;
            color: #333;
        }

        /* Contact Methods */
        .contact-methods {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 2rem;
            margin: 3rem 0;
        }

        .contact-card {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 2rem;
            border-radius: 20px;
            text-align: center;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .contact-card::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
            opacity: 0;
            transition: all 0.3s ease;
        }

        .contact-card:hover::before {
            opacity: 1;
            transform: scale(1.2);
        }

        .contact-card:hover {
            transform: scale(1.05);
        }

        .contact-icon {
            font-size: 2.5rem;
            margin-bottom: 1rem;
        }

        /* Timeline */
        .timeline {
            position: relative;
            margin: 3rem 0;
        }

        .timeline::before {
            content: '';
            position: absolute;
            left: 50%;
            top: 0;
            bottom: 0;
            width: 4px;
            background: linear-gradient(to bottom, #667eea, #764ba2);
            transform: translateX(-50%);
        }

        .timeline-item {
            margin: 2rem 0;
            position: relative;
        }

        .timeline-content {
            background: white;
            padding: 1.5rem;
            border-radius: 15px;
            box-shadow: 0 5px 15px var(--secondary-color);
            width: 45%;
            position: relative;
        }

        .timeline-item:nth-child(odd) .timeline-content {
            margin-left: auto;
        }

        .timeline-content::before {
            content: '';
            position: absolute;
            top: 50%;
            width: 20px;
            height: 20px;
            background: var(--primary-color);
            border-radius: 50%;
            border: 4px solid white;
            box-shadow: 0 0 0 4px var(--primary-color);
        }

        .timeline-item:nth-child(odd) .timeline-content::before {
            left: -45px;
        }

        .timeline-item:nth-child(even) .timeline-content::before {
            right: -45px;
        }

        /* Footer */
        footer {
            background: #333;
            color: white;
            padding: 3rem 0;
            text-align: center;
        }

        .footer-content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 2rem;
            margin-bottom: 2rem;
        }

        .footer-section h3 {
            margin-bottom: 1rem;
            color: var(--primary-color);
        }

        .footer-bottom {
            border-top: 1px solid var(--secondary-color);
            padding-top: 2rem;
            margin-top: 2rem;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .hero h1 {
                font-size: 2.5rem;
            }

            .nav-links {
                display: none;
            }

            .timeline::before {
                left: 20px;
            }

            .timeline-content {
                width: calc(100% - 60px);
                margin-left: 60px !important;
            }

            .timeline-content::before {
                left: -45px !important;
            }

            .cta-buttons {
                flex-direction: column;
                align-items: center;
            }
        }

        .scroll-indicator {
            position: absolute;
            bottom: 2rem;
            left: 50%;
            transform: translateX(-50%);
            color: white;
            font-size: 2rem;
            animation: bounce 2s infinite;
        }

        @keyframes bounce {
            0%, 20%, 50%, 80%, 100% {
                transform: translateX(-50%) translateY(0);
            }
            40% {
                transform: translateX(-50%) translateY(-10px);
            }
            60% {
                transform: translateX(-50%) translateY(-5px);
            }
        }

        .floating-elements {
            position: absolute;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: -1;
        }

        .floating-elements::before,
        .floating-elements::after {
            content: '';
            position: absolute;
            width: 200px;
            height: 200px;
            background: rgba(255,255,255,0.1);
            border-radius: 50%;
            animation: float 6s ease-in-out infinite;
        }

        .floating-elements::before {
            top: 20%;
            left: 10%;
            animation-delay: 0s;
        }

        .floating-elements::after {
            bottom: 20%;
            right: 10%;
            animation-delay: 3s;
        }

        @keyframes float {
            0%, 100% {
                transform: translateY(0px);
            }
            50% {
                transform: translateY(-20px);
            }
        }
    </style>
</head>
<body>
  <div class="top-banner">
    <div class="container">
        <div class="banner-content">
            <div class="fie-logo">
               <img src="{{ asset('assets/images/fie.jpg') }}" alt="FIE Burkina">
            </div>
            <div class="banner-text">
                <div class="banner-title">Fonds d'Intervention pour l'Environnement (FIE)</div>
                <div class="banner-subtitle">L'instrument financier de la politique environnementale du Burkina Faso</div>
            </div>
        </div>
    </div>
</div>
    <header>
        {{-- <div class="container-full bg-white">
          <p>
            <img src="{{ asset('assets/images/BanniereFr.jpg') }}" alt="">
            Fonds d'Intervention pour l'environnement (FIE)
          </p>
        </div> --}}
        <div class="container">
            <div class="header-content">
                {{-- <a href="#" class="logo">
                    <i class="fas fa-leaf"></i> FIE Burkina
                </a> --}}
                <nav>
                    <ul class="nav-links">
                        <li><a href="#accueil">Accueil</a></li>
                        <li><a href="#processus">Processus</a></li>
                        <li><a href="#contact">Contact</a></li>
                        <li><a href="#about">À Propos</a></li>
                    </ul>
                </nav>
            </div>
        </div>
    </header>

    <section class="hero" id="accueil">
        <div class="floating-elements"></div>
        <div class="container">
            <h1>Plaintes & Suggestions</h1>
            <p>Mécanisme de recours efficace et transparent pour toutes les parties prenantes. Votre voix compte dans la protection de l'environnement.</p>
            <div class="cta-buttons">
                <a href="#contact" class="btn btn-primary">
                    <i class="fas fa-paper-plane"></i>
                    Déposer une Plainte
                </a>
                <a href="#processus" class="btn btn-secondary">
                    <i class="fas fa-info-circle"></i>
                    Comment ça marche
                </a>
            </div>
        </div>
        <div class="scroll-indicator">
            <i class="fas fa-chevron-down"></i>
        </div>
    </section>

    <main>
        <section class="content-section" id="processus">
            <div class="container">
                <div class="section-header">
                    <h2>Notre Processus de Gestion</h2>
                    <p>Un système transparent et efficace en 8 étapes pour traiter vos préoccupations</p>
                </div>

                <div class="timeline">
                    <div class="timeline-item">
                        <div class="timeline-content">
                            <h3><i class="fas fa-clipboard"></i> Étape 1: Enregistrement</h3>
                            <p>Enregistrement de la plainte dans le registre dans un délai de 2 jours depuis la réception.</p>
                        </div>
                    </div>
                    <div class="timeline-item">
                        <div class="timeline-content">
                            <h3><i class="fas fa-sort-amount-up"></i> Étape 2: Évaluation</h3>
                            <p>Évaluer et traiter les plaintes par classement selon le niveau de priorité et d'importance.</p>
                        </div>
                    </div>
                    <div class="timeline-item">
                        <div class="timeline-content">
                            <h3><i class="fas fa-check-circle"></i> Étape 3: Confirmation</h3>
                            <p>Confirmer la réception de la plainte dans un délai de 3 jours dès sa réception.</p>
                        </div>
                    </div>
                    <div class="timeline-item">
                        <div class="timeline-content">
                            <h3><i class="fas fa-comments"></i> Étape 4: Communication</h3>
                            <p>Communication du FIE au dépositaire par écrit avec possibilité de recours sous 7 jours.</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="content-section">
            <div class="container">
                <div class="section-header">
                    <h2>Principes Fondamentaux</h2>
                    <p>Notre engagement pour un service équitable et accessible</p>
                </div>

                <div class="principles-grid">
                    <div class="principle-item">
                        <h4><i class="fas fa-eye"></i> Transparence et Équité</h4>
                        <p>Mécanisme facile à comprendre, transparent et disponible sans frais ni rétribution.</p>
                    </div>
                    <div class="principle-item">
                        <h4><i class="fas fa-universal-access"></i> Accessibilité</h4>
                        <p>Accessible à toutes les parties prenantes avec plusieurs options de dépôt disponibles.</p>
                    </div>
                    <div class="principle-item">
                        <h4><i class="fas fa-balance-scale"></i> Proportionnalité</h4>
                        <p>Mécanisme adapté à l'échelle et aux besoins spécifiques du FIE.</p>
                    </div>
                    <div class="principle-item">
                        <h4><i class="fas fa-clock"></i> Résolution Rapide</h4>
                        <p>Élimination de toutes les plaintes dans un délai d'un mois (30 jours).</p>
                    </div>
                    <div class="principle-item">
                        <h4><i class="fas fa-book"></i> Enregistrement</h4>
                        <p>Toutes les plaintes sont enregistrées et surveillées jusqu'à résolution complète.</p>
                    </div>
                    <div class="principle-item">
                        <h4><i class="fas fa-map-marked-alt"></i> Visites sur Site</h4>
                        <p>Discussions avec le plaignant et visites recommandées pour une compréhension maximale.</p>
                    </div>
                </div>
            </div>
        </section>

        <section class="content-section" id="contact">
            <div class="container">
                <div class="section-header">
                    <h2>Méthodes de Contact</h2>
                    <p>Choisissez la méthode qui vous convient le mieux</p>
                </div>

                <div class="contact-methods">
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-user"></i>
                        </div>
                        <h3>En Personne</h3>
                        <p>Déposition directe auprès de nos bureaux locaux</p>
                    </div>
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-users"></i>
                        </div>
                        <h3>Par Représentation</h3>
                        <p>Soumission via ONG ou association civile locale</p>
                    </div>
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <h3>Courrier Papier</h3>
                        <p>Envoi par voie postale traditionnelle</p>
                    </div>
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-at"></i>
                        </div>
                        <h3>Email</h3>
                        <p>Soumission électronique rapide et sécurisée</p>
                    </div>
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-phone"></i>
                        </div>
                        <h3>Téléphone</h3>
                        <p>Contact direct avec suivi écrit</p>
                    </div>
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-globe"></i>
                        </div>
                        <h3>Site Web</h3>
                        <p>Formulaire en ligne disponible 24h/24</p>
                    </div>
                </div>
            </div>
        </section>

        <section class="content-section">
            <div class="container">
                <div class="section-header">
                    <h2>Rôles et Responsabilités</h2>
                </div>

                <div class="process-grid">
                    <div class="process-card">
                        <div class="process-icon">
                            <i class="fas fa-users-cog"></i>
                        </div>
                        <h3>Comité Régionaux/Communaux</h3>
                        <p>S'assure du suivi des procédures et participe au processus de résolution des plaintes sensibles.</p>
                    </div>
                    <div class="process-card">
                        <div class="process-icon">
                            <i class="fas fa-inbox"></i>
                        </div>
                        <h3>Récepteurs de Plaintes</h3>
                        <p>Notifie le gestionnaire des plaintes dans les 48 heures suivant la réception.</p>
                    </div>
                    <div class="process-card">
                        <div class="process-icon">
                            <i class="fas fa-user-tie"></i>
                        </div>
                        <h3>Gestionnaire des Plaintes</h3>
                        <p>Responsable de l'intégrité générale du système et de la performance globale du processus.</p>
                    </div>
                    <div class="process-card">
                        <div class="process-icon">
                            <i class="fas fa-handshake"></i>
                        </div>
                        <h3>Parties Prenantes</h3>
                        <p>Communiquent leurs commentaires, suggestions et plaintes via le mécanisme établi.</p>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer>
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <h3>Contact</h3>
                    <p><i class="fas fa-map-marker-alt"></i> Ouagadougou, Burkina Faso</p>
                    <p><i class="fas fa-envelope"></i> contact@fie-burkina.org</p>
                    <p><i class="fas fa-phone"></i> +226 XX XX XX XX</p>
                </div>
                <div class="footer-section">
                    <h3>Liens Utiles</h3>
                    <p><a href="#" style="color: #ccc; text-decoration: none;">Accueil</a></p>
                    <p><a href="#" style="color: #ccc; text-decoration: none;">À Propos</a></p>
                    <p><a href="#" style="color: #ccc; text-decoration: none;">Projets</a></p>
                    <p><a href="#" style="color: #ccc; text-decoration: none;">Publications</a></p>
                </div>
                <div class="footer-section">
                    <h3>Suivez-nous</h3>
                    <div style="display: flex; gap: 1rem; justify-content: center;">
                        <a href="#" style="color: #ccc; font-size: 1.5rem;"><i class="fab fa-facebook"></i></a>
                        <a href="#" style="color: #ccc; font-size: 1.5rem;"><i class="fab fa-twitter"></i></a>
                        <a href="#" style="color: #ccc; font-size: 1.5rem;"><i class="fab fa-linkedin"></i></a>
                    </div>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; 2024 FIE Burkina. Tous droits réservés. | Mécanisme de gestion des plaintes et suggestions</p>
            </div>
        </div>
    </footer>

    <script>
        // Smooth scrolling for navigation links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });

        // Add scroll effect to header
        window.addEventListener('scroll', () => {
            const header = document.querySelector('header');
            if (window.scrollY > 100) {
                header.style.background = 'rgba(1, 141, 55, 0.9)';
                header.style.backdropFilter = 'blur(20px)';
            } else {
                header.style.background = 'rgba(1, 141, 55, 0.9)';
                // header.style.background = 'rgba(255, 255, 255, 0.1)';
                header.style.backdropFilter = 'blur(10px)';
            }
        });

        // Animate elements on scroll
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        };

        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, observerOptions);

        // Observe timeline items
        document.querySelectorAll('.timeline-item, .process-card, .principle-item, .contact-card').forEach(item => {
            item.style.opacity = '0';
            item.style.transform = 'translateY(30px)';
            item.style.transition = 'all 0.6s ease';
            observer.observe(item);
        });

        // Add click handlers for CTA buttons
        document.querySelector('.btn-primary').addEventListener('click', function(e) {
            e.preventDefault();
            // Here you could open a modal or redirect to a form
            alert('Fonction de dépôt de plainte à implémenter. Contactez-nous via les méthodes listées ci-dessous.');
        });
    </script>
</body>
</html>